
package itineraryfinder;

import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

/**
 *
 * @author Andrea Barbagallo
 */
public class Main extends Application {
    
    @Override
    public void start(Stage stage) throws Exception {
        
        FXMLLoader loader = new FXMLLoader(getClass().getResource("ItineraryFinderFXML.fxml"));
        Parent root = loader.load();
        Scene scene = new Scene(root);
        
        ItineraryFinderController controller = loader.getController();
        controller.setHostServices(getHostServices());
        stage.setScene(scene);
        stage.setTitle("Itinerary Finder");
        stage.setResizable(false);
        
        stage.show();
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }
    
}
